/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIPropertyChangeSupport {
    private HashMap propertyChangeListeners;
    private Object propertyChangeListenersLock = new Object();
    private static final String TRACE_MASKT = "HUIPCE T";
    private static final String TRACE_MASKF = "HUIPCE F";
    private static final String TRACE_MASKD = "HUIPCE D";

    UIPropertyChangeSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, String shortId, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "-> UIPropertyChangeSupport.addPropertyChangeListener()");
        Object object = this.propertyChangeListenersLock;
        synchronized (object) {
            ArrayList<String> propertyNames;
            HashMap<String, ArrayList<String>> shortIdMap;
            HashMap listenerMap;
            if (this.propertyChangeListeners == null) {
                this.propertyChangeListeners = new HashMap();
            }
            if ((listenerMap = (HashMap)this.propertyChangeListeners.get(listener)) == null) {
                listenerMap = new HashMap();
                this.propertyChangeListeners.put(listener, listenerMap);
            }
            if ((shortIdMap = (HashMap<String, ArrayList<String>>)listenerMap.get(shortId)) == null) {
                shortIdMap = new HashMap<String, ArrayList<String>>();
                listenerMap.put(shortId, shortIdMap);
            }
            if ((propertyNames = (ArrayList<String>)shortIdMap.get(shortId)) == null) {
                propertyNames = new ArrayList<String>();
                shortIdMap.put(shortId, propertyNames);
            }
            propertyNames.add(propertyName);
            Trace.trace(TRACE_MASKF, "   added listener " + listener + " for property " + propertyName + " in shortId " + shortId);
        }
        Trace.trace(TRACE_MASKF, "<- UIPropertyChangeSupport.addPropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, String shortId, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "-> UIPropertyChangeSupport.removePropertyChangeListener()");
        Object object = this.propertyChangeListenersLock;
        synchronized (object) {
            if (this.propertyChangeListeners != null) {
                Map listenerMap = (Map)this.propertyChangeListeners.get(listener);
                if (listenerMap != null) {
                    Map shortIdMap = (Map)listenerMap.get(shortId);
                    if (shortIdMap != null) {
                        List propertyNames = (List)shortIdMap.get(shortId);
                        if (propertyNames != null) {
                            if (!propertyNames.remove(propertyName)) {
                                Trace.trace(TRACE_MASKF, "   Error, listener not removed because the listener was not added for shortId " + shortId + " and property name " + propertyName);
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "   Error, listener not removed because the listener was not added for shortId " + shortId);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "   Error, listener not removed because the listener was not added for shortId " + shortId);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "   Error, listener not removed because the listener was not added");
                }
            } else {
                Trace.trace(TRACE_MASKF, "   Error, listener not removed because the listener was not added");
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIPropertyChangeSupport.removePropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPropertyChangeListener(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKF, "-> UIPropertyChangeSupport.notifyPropertyChangeListener()");
        List listeners = null;
        Object object = this.propertyChangeListenersLock;
        synchronized (object) {
            if (this.propertyChangeListeners != null) {
                String shortId = (String)evt.getSource();
                String propertyName = evt.getPropertyName();
                Trace.trace(TRACE_MASKF, "   source is " + shortId + ", property name is " + propertyName);
                Trace.trace(TRACE_MASKF, "   number of listeners is " + this.propertyChangeListeners.size());
                Iterator iterator = this.propertyChangeListeners.keySet().iterator();
                while (iterator.hasNext()) {
                    PropertyChangeListener listener = (PropertyChangeListener)iterator.next();
                    Map listenerMap = (Map)this.propertyChangeListeners.get(listener);
                    if (listenerMap != null) {
                        Trace.trace(TRACE_MASKF, "   number of shortIds for this listener is " + listenerMap.size());
                        Map shortIdMap = (Map)listenerMap.get(shortId);
                        if (shortIdMap != null) {
                            Trace.trace(TRACE_MASKF, "   number of properties for this shortId and listener is " + shortIdMap.size());
                            List propertyNames = (List)shortIdMap.get(shortId);
                            if (propertyNames != null) {
                                if (propertyNames.contains(propertyName)) {
                                    listener.propertyChange(evt);
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "   propertyNames does not contain " + propertyName);
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "   propertyNames is null");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "   shortIdMap is null");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "   listenerMap is null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "   there are no PropertyChangeListeners");
            }
        }
        if (listeners != null) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((PropertyChangeListener)iterator.next()).propertyChange(evt);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIPropertyChangeSupport.notifyPropertyChangeListener()");
    }
}

